package org.msh.tb.bd.tbforms.dhis2.tb10.blockbuilders;

import org.msh.tb.bd.tbforms.query.tb10.TBForm10Block4Query;
import org.msh.tb.bd.tbforms.dhis2.TBFormBlockBuilder;
import org.msh.tb.bd.tbforms.dhis2.data.DataValuePayload;
import org.msh.tb.entities.enums.TbFormField;

/**
 * Created by Mauricio on 17/02/2017.
 * Query database and mount TB Form 10 Block 4 Payload to be sent to DHIS2 APIs
 */
public class TBForm10Block4Builder extends TBFormBlockBuilder {

    private TBForm10Block4Query formQuery;

    @Override
    protected void loadAllFieldsAsZero(DataValuePayload payload) {
        for (TbFormField field : getBlockQuery().fields) {
            payload.mergeDataValue(field.getDhis2DataElementId(), field.getDhis2CategoryOptionComboId(), new Long(0));
        }
    }

    @Override
    protected TBForm10Block4Query getBlockQuery() {
        if (formQuery == null) {
            formQuery = new TBForm10Block4Query();
        }

        return formQuery;
    }

    @Override
    protected void mountResultPayload(Object[] result, DataValuePayload payload) {
        TbFormField field = (TbFormField) result[0];
        Integer count = (Integer) result[1];

        // merge payload result
        payload.mergeDataValue(field.getDhis2DataElementId(), field.getDhis2CategoryOptionComboId(), new Long(count));
    }
}
